#include "nr.h"

wavefilt *wfilt_p;

void NR::pwtset(const int n)
{
	const static DP c4_d[4]=
		{0.4829629131445341,0.8365163037378079,
		0.2241438680420134,-0.1294095225512604};
	const static DP c12_d[12]=
		{0.111540743350, 0.494623890398, 0.751133908021,
		0.315250351709,-0.226264693965,-0.129766867567,
		0.097501605587, 0.027522865530,-0.031582039318,
		0.000553842201, 0.004777257511,-0.001077301085};
	const static DP c20_d[20]=
		{0.026670057901, 0.188176800078, 0.527201188932,
		0.688459039454, 0.281172343661,-0.249846424327,
		-0.195946274377, 0.127369340336, 0.093057364604,
		-0.071394147166,-0.029457536822, 0.033212674059,
		0.003606553567,-0.010733175483, 0.001395351747,
		0.001992405295,-0.000685856695,-0.000116466855,
		0.000093588670,-0.000013264203};

	if (n == 4)
		wfilt_p=new wavefilt(c4_d,n);
	else if (n == 12)
		wfilt_p=new wavefilt(c12_d,n);
	else if (n == 20)
		wfilt_p=new wavefilt(c20_d,n);
	else nrerror("unimplemented value n in pwtset");
}
